<!DOCTYPE HTML>
<!--
Editorial by HTML5 UP
html5up.net | @ajlkn
Free for personal and commercial use under the CCA 3.0 license (html5up.net/license)
-->
<html lang="en">
	<head>
		<title><?php page_title('','[WEBSITE_TITLE]'); ?></title>
		<meta http-equiv="Content-Type" content="text/html; charset=<?php echo DEFAULT_CHARSET; ?>">
		<meta name="description" content="<?php page_description(); ?>">
		<meta name="keywords" content="<?php page_keywords(); ?>">
		<meta name="robots" content="index,follow">
		<meta name="revisit-after" content="14 days">
		<meta name="generator" content="Websitebaker">
		<meta name="viewport" content="width=auto, initial-scale=1">
		<link rel="stylesheet" href="<?php echo TEMPLATE_DIR; ?>/assets/css/klaro.css">
		<link rel="stylesheet" href="<?php echo TEMPLATE_DIR; ?>/assets/css/main.css">
		<?php register_frontend_modfiles('css');?>
	</head>
	<body class="is-preload">

		<!-- Wrapper -->
			<div id="wrapper">

				<!-- Main -->
					<div id="main">
						<div class="inner">

							<!-- Header -->
								<header id="header">
									<a href="<?= WB_URL;?>" class="logo"><?php page_header(); ?></a>
									<ul class="icons">
										<li><a href="https://www.facebook.com/matthias.gallas" class="icon brands fa-facebook-f"><span class="label">Facebook</span></a></li>
										<li><a href="https://www.instagram.com/matthiasgallas/" class="icon brands fa-instagram"><span class="label">Instagram</span></a></li>
									</ul>
								</header>

							<!-- Content -->
								<section>
									<header class="main">
										<h1>[[ShowRootParent]]</h1>
									</header>
									<?php page_content(); ?>
								</section>

						</div>
					</div>

				<!-- Sidebar -->
					<div id="sidebar">
						<div class="inner">

							<!-- Search -->
								<section id="search" class="alt">
									<h6>&nbsp;</h6><!-- only needed for to prevent validation Erros -->
									<form name="searchpage" action="<?php echo WB_URL.'/search/index.php'; ?>" method="get">
										<input type="hidden" name="referrer" value="<?php echo defined('REFERRER_ID') ? REFERRER_ID : PAGE_ID; ?>">
										<input type="text" name="string" placeholder="<?php echo $TEXT['SEARCH']; ?>">
									</form>
								</section>

							<!-- Menu -->
								<nav id="menu">
									<header class="major">
										<h2>Menu</h2>
									</header>
									<?php show_menu2(0, SM2_ROOT, SM2_CURR+1, SM2_ALL|SM2_PRETTY, '[if(class==menu-expand){<li><span class="opener">[menu_title]</span>} else {<li><a href="[url]">[menu_title]</a>}]', '</li>', '<ul>', '</ul>'); ?>
								</nav>

							<!-- Section -->
								<section>
									<header class="major">
										<h2>Get in touch</h2>
									</header>
									<ul class="contact">
										<li class="icon solid fa-envelope"><a href="mailto:info@ruebenwurzel.de">info@ruebenwurzel.de</a></li>
										<li class="icon solid fa-phone">+49 (0) 1 73 / 3 93 31 69</li>
										<li class="icon solid fa-home">Lindtalstraße 31<br>
										97896 Freudenberg</li>
									</ul>
								</section>

							<!-- Footer -->
								<footer id="footer">
									<p class="copyright"><?php page_footer(); ?> - Design: <a href="https://html5up.net">HTML5 UP</a>.</p>
								</footer>

						</div>
					</div>

			</div>
		<!-- Scripts -->
		<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/jquery.min.js"></script>
		<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/browser.min.js"></script>
		<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/breakpoints.min.js"></script>
		<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/util.js"></script>
		<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/main.js"></script>

		<!-- automatically include optional WB module file frontend_body.js) should be always set -->
		<?php register_frontend_modfiles_body('js'); ?>
		
		<!-- add Klaro Cookie Banner -->
		<script	defer  src="<?= TEMPLATE_DIR; ?>/assets/js/config.js"></script>
		<script
			defer
			data-config="klaroConfig"
			src="<?= TEMPLATE_DIR; ?>/assets/js/klaro-no-css.js">
		</script>
	</body>
</html>